# Xero Integration Setup Guide

## Current Status
The system is currently in **Demo Mode** - invoices are simulated and not actually created in your Xero account.

## To Enable Real Xero Integration

### Step 1: Get Xero Credentials
1. Go to [developer.xero.com](https://developer.xero.com)
2. Sign in with your Xero account
3. Click "New App" or "Add App"
4. Fill in the app details:
   - **App Name**: RefurbFlow Ordering System
   - **App URL**: http://localhost:8080/in-house-app/
   - **Redirect URI**: http://localhost:8080/in-house-app/index.html
5. Note down your **Client ID** and **Client Secret**

### Step 2: Configure the PHP API
1. Open `xero-api.php` in a text editor
2. Replace `YOUR_XERO_CLIENT_ID` with your actual Client ID
3. Replace `YOUR_XERO_CLIENT_SECRET` with your actual Client Secret
4. Save the file

### Step 3: Test the Integration
1. Go to Settings → Xero Integration
2. Click "Connect to Xero"
3. Enter your Client ID and Client Secret
4. Click "Test Connection"
5. If successful, click "Save Configuration"

### Step 4: Create Real Invoices
1. Go to any job in the system
2. Click "Ready" button
3. The system will now create actual invoices in your Xero account
4. Check your Xero account to see the created invoice

## Important Notes

### Security Considerations
- The current setup stores credentials in localStorage (not secure for production)
- For production use, implement proper server-side OAuth2 flow
- Never expose Client Secret in client-side code

### Demo Mode
- When in demo mode, invoices are logged to the server error log
- Check your web server error logs to see simulated invoice data
- Demo mode is safe for testing and demonstration

### Troubleshooting
- Make sure your web server supports PHP
- Check browser console for error messages
- Verify Xero app configuration matches your setup
- Ensure redirect URI is exactly as configured in Xero

## File Structure
```
in-house-app/
├── xero-api.php          # Server-side Xero API handler
├── XERO_SETUP_GUIDE.md   # This guide
├── js/xero-config.js     # Client-side configuration
└── index.html            # Main application
```

## API Endpoints
- `xero-api.php?action=test_connection` - Test Xero credentials
- `xero-api.php?action=create_invoice` - Create invoice in Xero
- `xero-api.php?action=auth_url` - Get OAuth2 authorization URL

## Support
If you encounter issues:
1. Check the browser console for errors
2. Verify your Xero app configuration
3. Ensure PHP is properly configured on your server
4. Check server error logs for detailed error messages
