<?php
// Simple Xero Authorization Page
$XERO_CLIENT_ID = '4A904E9EF43249648C8CA3198BC84627';
$XERO_REDIRECT_URI = 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php';
$XERO_SCOPE = 'accounting.transactions accounting.contacts.read accounting.settings.read offline_access';

$authUrl = 'https://login.xero.com/identity/connect/authorize' . '?' . http_build_query([
    'response_type' => 'code',
    'client_id' => $XERO_CLIENT_ID,
    'redirect_uri' => $XERO_REDIRECT_URI,
    'scope' => $XERO_SCOPE,
    'state' => 'xero_auth_state'
]);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Xero Authorization</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; }
        .container { max-width: 600px; margin: 0 auto; }
        .btn { 
            display: inline-block; 
            padding: 15px 30px; 
            background: #13B5EA; 
            color: white; 
            text-decoration: none; 
            border-radius: 5px; 
            font-size: 16px;
            margin: 20px 0;
        }
        .btn:hover { background: #0EA5D8; }
        .info { background: #f0f8ff; padding: 15px; border-radius: 5px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔗 Xero Authorization</h1>
        
        <div class="info">
            <h3>Step 1: Authorize the App</h3>
            <p>Click the button below to authorize the RefurbFlow app with your Xero account.</p>
            <a href="<?php echo $authUrl; ?>" class="btn">Authorize with Xero</a>
        </div>
        
        <div class="info">
            <h3>Step 2: After Authorization</h3>
            <p>You'll be redirected back to this page with an authorization code. The system will automatically:</p>
            <ul>
                <li>Exchange the code for access tokens</li>
                <li>Get your Xero tenant ID</li>
                <li>Store the credentials securely</li>
                <li>Enable invoice creation</li>
            </ul>
        </div>
        
        <div class="info">
            <h3>Step 3: Test Integration</h3>
            <p>Once authorized, go to your RefurbFlow app and click "Ready" on any job to create a real invoice in Xero!</p>
            <a href="index.html" class="btn">Go to RefurbFlow App</a>
        </div>
        
        <div class="info">
            <h3>Authorization URL:</h3>
            <code style="word-break: break-all; font-size: 12px;"><?php echo $authUrl; ?></code>
        </div>
    </div>
</body>
</html>
