<?php
// Check for specific contact details
echo "=== Checking Specific Contact ===\n\n";

require_once 'vendor/autoload.php';

use XeroAPI\XeroPHP\Api\AccountingApi;
use XeroAPI\XeroPHP\Configuration;
use GuzzleHttp\Client;

// Load tokens
$tokens = json_decode(file_get_contents('xero_tokens.json'), true);
$accessToken = $tokens['access_token'];
$tenantId = $tokens['tenant_id'];

// Configure Xero API
$config = Configuration::getDefaultConfiguration();
$config->setAccessToken($accessToken);
$config->setHost('https://api.xero.com');

$guzzleClient = new Client([
    'verify' => false,
    'timeout' => 30
]);

$apiInstance = new AccountingApi($guzzleClient, $config);

try {
    // Get all contacts
    $contacts = $apiInstance->getContacts($tenantId);
    
    echo "1. Searching for 'Tesco Bank Insurance'...\n";
    
    $foundContact = null;
    foreach ($contacts->getContacts() as $contact) {
        if ($contact->getName() === 'Tesco Bank Insurance') {
            $foundContact = $contact;
            break;
        }
    }
    
    if ($foundContact) {
        echo "   ✅ Found contact!\n";
        echo "   Contact ID: " . $foundContact->getContactID() . "\n";
        echo "   Name: " . $foundContact->getName() . "\n";
        echo "   Email: " . ($foundContact->getEmailAddress() ?? 'Not set') . "\n";
        echo "   Phone: " . (count($foundContact->getPhones()) > 0 ? $foundContact->getPhones()[0]->getPhoneNumber() : 'Not set') . "\n";
        
        $addresses = $foundContact->getAddresses();
        if (!empty($addresses)) {
            $addr = $addresses[0];
            echo "   Address: " . $addr->getAddressLine1() . "\n";
            echo "   City: " . $addr->getCity() . "\n";
            echo "   Postcode: " . $addr->getPostalCode() . "\n";
            echo "   Country: " . $addr->getCountry() . "\n";
        } else {
            echo "   Address: Not set\n";
        }
        
        echo "   Is Customer: " . ($foundContact->getIsCustomer() ? 'Yes' : 'No') . "\n";
        echo "   Status: " . $foundContact->getContactStatus() . "\n";
    } else {
        echo "   ❌ Contact not found\n";
    }
    
    echo "\n2. All contacts with 'Tesco' in name:\n";
    foreach ($contacts->getContacts() as $contact) {
        if (stripos($contact->getName(), 'Tesco') !== false) {
            echo "   - " . $contact->getName() . " (ID: " . $contact->getContactID() . ")\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== Check Complete ===\n";
?>
