<?php
// Check Xero Authorization Status
header('Content-Type: application/json');

$tokensFile = 'xero_tokens.json';

if (file_exists($tokensFile)) {
    $tokens = json_decode(file_get_contents($tokensFile), true);
    
    if ($tokens && isset($tokens['access_token'])) {
        $status = [
            'authorized' => true,
            'access_token' => substr($tokens['access_token'], 0, 20) . '...',
            'tenant_id' => $tokens['tenant_id'] ?? 'Not set',
            'expires_in' => $tokens['expires_in'] ?? 'Not set',
            'created_at' => isset($tokens['created_at']) ? date('Y-m-d H:i:s', $tokens['created_at']) : 'Not set',
            'message' => 'Xero is authorized and ready to create invoices!'
        ];
    } else {
        $status = [
            'authorized' => false,
            'message' => 'Invalid token file'
        ];
    }
} else {
    $status = [
        'authorized' => false,
        'message' => 'No authorization found. Please authorize the app first.'
    ];
}

echo json_encode($status, JSON_PRETTY_PRINT);
?>
