<?php
// Explain where the tenant ID comes from
echo "=== Xero Tenant ID Source Explanation ===\n\n";

echo "1. WHERE THE TENANT ID COMES FROM:\n";
echo "   The tenant ID comes from Xero's OAuth2 authorization process.\n";
echo "   Here's the complete flow:\n\n";

echo "   Step 1: User authorizes the app\n";
echo "   ↓\n";
echo "   Step 2: Xero redirects back with authorization code\n";
echo "   ↓\n";
echo "   Step 3: We exchange code for access token\n";
echo "   ↓\n";
echo "   Step 4: We call Xero's /connections endpoint to get tenant info\n";
echo "   ↓\n";
echo "   Step 5: We store the tenant_id in xero_tokens.json\n\n";

echo "2. CURRENT STORED TOKENS:\n";
$tokens = json_decode(file_get_contents('xero_tokens.json'), true);
echo "   Access Token: " . substr($tokens['access_token'], 0, 50) . "...\n";
echo "   Tenant ID: " . $tokens['tenant_id'] . "\n";
echo "   Expires In: " . $tokens['expires_in'] . " seconds\n";
echo "   Created At: " . date('Y-m-d H:i:s', $tokens['created_at']) . "\n\n";

echo "3. HOW WE GET THE TENANT ID:\n";
echo "   In xero-sdk-api.php, the getTenantId() function:\n";
echo "   - Calls: https://api.xero.com/connections\n";
echo "   - Uses the access token for authentication\n";
echo "   - Xero returns a list of connected organizations\n";
echo "   - We take the first one's tenantId\n\n";

echo "4. WHY WE NEED THE TENANT ID:\n";
echo "   - Xero allows one app to connect to multiple organizations\n";
echo "   - Each organization has a unique tenant_id\n";
echo "   - All API calls must specify which organization (tenant) to use\n";
echo "   - Without tenant_id, Xero doesn't know which organization to create the invoice in\n\n";

echo "5. WHERE IT'S USED IN INVOICE CREATION:\n";
echo "   - In createInvoiceWithSDK() function\n";
echo "   - Passed to: \$apiInstance->createInvoices(\$tenantId, \$invoices)\n";
echo "   - This tells Xero which organization to create the invoice in\n\n";

echo "6. YOUR CURRENT TENANT ID:\n";
echo "   " . $tokens['tenant_id'] . "\n";
echo "   This is your Xero organization's unique identifier\n";
echo "   All invoices will be created in this organization\n\n";

echo "=== Summary ===\n";
echo "The tenant ID comes from Xero's /connections API endpoint\n";
echo "and represents your specific Xero organization.\n";
echo "It's automatically obtained during the OAuth2 authorization process\n";
echo "and stored for use in all subsequent API calls.\n";
?>
