// Xero API Configuration
// For demonstration purposes - in production, these should be environment variables
window.XeroConfig = {
    // Xero App Credentials (replace with your actual app credentials)
    clientId: '4A904E9EF43249648C8CA3198BC84627',
    clientSecret: 'FdtU6vAMbr3rDXscm8o_WurBMHm2vuZ_7eHoIvPbCDlC-NWF',
    redirectUri: 'http://localhost:8080/in-house-app/index.html',
    
    // Xero API Endpoints
    apiBaseUrl: 'https://api.xero.com',
    accountingApiUrl: 'https://api.xero.com/api.xro/2.0',
    
    // Scopes required for invoice creation
    scopes: [
        'accounting.transactions',
        'accounting.contacts.read',
        'accounting.settings.read'
    ],
    
    // Demo mode flag
    demoMode: true,
    
    // Demo invoice data
    demoInvoiceData: {
        contactId: 'demo-contact-id',
        contactName: 'Wheels Automotive Ltd',
        lineItems: [
            {
                description: 'Wheel Refurbishment Service',
                quantity: 1,
                unitAmount: 0,
                accountCode: '200',
                taxType: 'OUTPUT'
            }
        ],
        reference: 'AUTO-INV-',
        dueDate: 30
    }
};

// Xero Authentication Helper
window.XeroAuth = {
    // Check if user is authenticated
    isAuthenticated: function() {
        return localStorage.getItem('xero_access_token') !== null;
    },
    
    // Get stored access token
    getAccessToken: function() {
        return localStorage.getItem('xero_access_token');
    },
    
    // Store access token
    setAccessToken: function(token) {
        localStorage.setItem('xero_access_token', token);
    },
    
    // Clear authentication
    clearAuth: function() {
        localStorage.removeItem('xero_access_token');
        localStorage.removeItem('xero_refresh_token');
        localStorage.removeItem('xero_tenant_id');
    },
    
    // Get authorization URL
    getAuthUrl: function() {
        const config = window.XeroConfig;
        const params = new URLSearchParams({
            response_type: 'code',
            client_id: config.clientId,
            redirect_uri: config.redirectUri,
            scope: config.scopes.join(' '),
            state: 'xero_auth_state'
        });
        
        return `https://login.xero.com/identity/connect/authorize?${params.toString()}`;
    }
};
