<?php
// List all Xero tenants (organizations) that the app has access to
echo "=== Xero Tenants List ===\n\n";

// Load stored tokens
$tokensFile = 'xero_tokens.json';
if (!file_exists($tokensFile)) {
    echo "❌ No tokens found. Please authorize the app first.\n";
    exit;
}

$tokens = json_decode(file_get_contents($tokensFile), true);
if (!$tokens || !isset($tokens['access_token'])) {
    echo "❌ Invalid token file. Please re-authorize the app.\n";
    exit;
}

$accessToken = $tokens['access_token'];
echo "1. Using access token: " . substr($accessToken, 0, 50) . "...\n\n";

echo "2. Calling Xero /connections endpoint...\n";

// Call Xero's connections endpoint
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.xero.com/connections');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $accessToken,
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "3. API Response:\n";
echo "   HTTP Code: $httpCode\n";
if ($error) {
    echo "   Error: $error\n";
    exit;
}

echo "   Raw Response: " . $response . "\n\n";

// Parse the response
$connections = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo "❌ Failed to parse JSON response: " . json_last_error_msg() . "\n";
    exit;
}

echo "4. Parsed Tenants List:\n";
if (empty($connections)) {
    echo "   ❌ No tenants found. This might indicate an issue with the access token.\n";
} else {
    echo "   ✅ Found " . count($connections) . " tenant(s):\n\n";
    
    foreach ($connections as $index => $tenant) {
        echo "   Tenant #" . ($index + 1) . ":\n";
        echo "   ├─ Tenant ID: " . ($tenant['tenantId'] ?? 'Not provided') . "\n";
        echo "   ├─ Tenant Type: " . ($tenant['tenantType'] ?? 'Not provided') . "\n";
        echo "   ├─ Tenant Name: " . ($tenant['tenantName'] ?? 'Not provided') . "\n";
        echo "   ├─ Created Date: " . ($tenant['createdDateUtc'] ?? 'Not provided') . "\n";
        echo "   └─ Updated Date: " . ($tenant['updatedDateUtc'] ?? 'Not provided') . "\n\n";
    }
    
    // Show which tenant is currently being used
    $currentTenantId = $tokens['tenant_id'] ?? 'Not set';
    echo "5. Currently Active Tenant:\n";
    echo "   Tenant ID: $currentTenantId\n";
    
    // Find the current tenant in the list
    $currentTenant = null;
    foreach ($connections as $tenant) {
        if (($tenant['tenantId'] ?? '') === $currentTenantId) {
            $currentTenant = $tenant;
            break;
        }
    }
    
    if ($currentTenant) {
        echo "   Tenant Name: " . ($currentTenant['tenantName'] ?? 'Not provided') . "\n";
        echo "   Status: ✅ Active (invoices will be created here)\n";
    } else {
        echo "   Status: ❌ Not found in current connections\n";
    }
}

echo "\n=== Tenants List Complete ===\n";
?>
