<?php
// Re-authorize Xero to get fresh tokens
echo "=== Xero Re-authorization ===\n\n";

// Delete old tokens
if (file_exists('xero_tokens.json')) {
    unlink('xero_tokens.json');
    echo "✅ Old tokens deleted\n";
}

// Generate new authorization URL
$clientId = '4A904E9EF43249648C8CA3198BC84627';
$redirectUri = 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php';
$scope = 'accounting.transactions accounting.contacts accounting.settings.read offline_access';
$state = 'xero_auth_state';

$authUrl = 'https://login.xero.com/identity/connect/authorize?' . http_build_query([
    'response_type' => 'code',
    'client_id' => $clientId,
    'redirect_uri' => $redirectUri,
    'scope' => $scope,
    'state' => $state
]);

echo "🔗 Please visit this URL to re-authorize:\n";
echo $authUrl . "\n\n";

echo "After authorization, the system will automatically get fresh tokens.\n";
echo "Then you can test invoice creation again.\n\n";

echo "=== Instructions ===\n";
echo "1. Click the URL above\n";
echo "2. Log in to Xero and authorize the app\n";
echo "3. You'll be redirected back with a fresh authorization code\n";
echo "4. The system will automatically exchange it for new tokens\n";
echo "5. Then run: php test-php-only-data.php\n";
?>
