<?php
// Test detailed wheel service invoice creation
echo "=== Testing Detailed Wheel Service Invoice ===\n\n";

// Sample detailed invoice data for wheel services
$invoiceData = [
    'jobId' => 1001,
    'customer' => 'Aviva Insurance Ltd',
    'description' => 'BMW X5 21" Alloy Wheels - Kerb damage repair',
    'amount' => 320.00,
    'service' => 'Diamond Cut',
    'regNo' => 'BM21 X5A',
    'addons' => [
        [
            'description' => 'Wheel Balancing Service',
            'quantity' => 4,
            'amount' => 15.00
        ],
        [
            'description' => 'Valve Replacement (Titanium)',
            'quantity' => 4,
            'amount' => 8.00
        ],
        [
            'description' => 'Express Service (24hr turnaround)',
            'quantity' => 1,
            'amount' => 50.00
        ]
    ]
];

echo "1. Detailed Invoice Data:\n";
echo json_encode($invoiceData, JSON_PRETTY_PRINT) . "\n\n";

echo "2. Calling Xero SDK API...\n";

// Make the API call
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php?action=create_invoice');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['invoiceData' => $invoiceData]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "3. API Response:\n";
echo "   HTTP Code: $httpCode\n";
if ($error) {
    echo "   Error: $error\n";
} else {
    echo "   Response: " . $response . "\n\n";
    
    $result = json_decode($response, true);
    if ($result) {
        echo "4. Parsed Response:\n";
        echo json_encode($result, JSON_PRETTY_PRINT) . "\n\n";
        
        if (isset($result['InvoiceID'])) {
            echo "✅ SUCCESS: Detailed invoice created in Xero!\n";
            echo "   Invoice ID: " . $result['InvoiceID'] . "\n";
            echo "   Invoice Number: " . $result['InvoiceNumber'] . "\n";
            echo "   Status: " . $result['Status'] . "\n";
            echo "   Customer: " . $result['Contact']['Name'] . "\n";
            echo "   Total Line Items: " . count($result['LineItems']) . "\n\n";
            
            echo "5. Line Items Breakdown:\n";
            $totalAmount = 0;
            foreach ($result['LineItems'] as $index => $item) {
                $lineTotal = ($item['Quantity'] ?? 1) * ($item['UnitAmount'] ?? 0);
                $totalAmount += $lineTotal;
                echo "   " . ($index + 1) . ". " . ($item['Description'] ?? 'Unknown') . "\n";
                echo "      Qty: " . ($item['Quantity'] ?? 1) . " x £" . number_format($item['UnitAmount'] ?? 0, 2) . " = £" . number_format($lineTotal, 2) . "\n";
            }
            echo "   Total Invoice Amount: £" . number_format($totalAmount, 2) . "\n";
        } else {
            echo "❌ ERROR: " . ($result['error'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Failed to parse JSON response\n";
    }
}

echo "\n=== Test Complete ===\n";
?>
