<?php
// Test with a fresh authorization code
echo "=== Xero OAuth2 Test with Fresh Code ===\n\n";

// Generate a fresh authorization URL
$XERO_CLIENT_ID = '4A904E9EF43249648C8CA3198BC84627';
$XERO_REDIRECT_URI = 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php';
$XERO_SCOPE = 'accounting.transactions accounting.contacts.read accounting.settings.read offline_access';

$authUrl = 'https://login.xero.com/identity/connect/authorize' . '?' . http_build_query([
    'response_type' => 'code',
    'client_id' => $XERO_CLIENT_ID,
    'redirect_uri' => $XERO_REDIRECT_URI,
    'scope' => $XERO_SCOPE,
    'state' => 'xero_auth_state'
]);

echo "1. Fresh Authorization URL:\n";
echo $authUrl . "\n\n";

echo "2. Instructions:\n";
echo "   - Copy the URL above\n";
echo "   - Open it in your browser\n";
echo "   - Sign in to Xero and authorize the app\n";
echo "   - You'll be redirected back with a fresh code\n";
echo "   - The system will automatically handle the token exchange\n\n";

echo "3. After authorization, check status:\n";
echo "   http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/check-xero-status.php\n\n";

echo "4. Test invoice creation:\n";
echo "   - Go to your RefurbFlow app\n";
echo "   - Click 'Ready' on any job\n";
echo "   - Check your Xero account for the invoice!\n\n";

echo "=== Ready to Test! ===\n";
?>
