<?php
// Test invoice creation using the Xero SDK API
echo "=== Testing Xero Invoice Creation ===\n\n";

// Sample invoice data
$invoiceData = [
    'jobId' => 999,
    'customer' => 'Test Customer Ltd',
    'description' => 'BMW X5 21" Diamond Cut Wheels - Test Invoice',
    'amount' => 450.00,
    'service' => 'Diamond Cut',
    'regNo' => 'TEST123'
];

echo "1. Invoice Data:\n";
echo json_encode($invoiceData, JSON_PRETTY_PRINT) . "\n\n";

echo "2. Calling Xero SDK API...\n";

// Make the API call
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php?action=create_invoice');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['invoiceData' => $invoiceData]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "3. API Response:\n";
echo "   HTTP Code: $httpCode\n";
if ($error) {
    echo "   Error: $error\n";
} else {
    echo "   Response: " . $response . "\n";
}

echo "\n4. Parsed Response:\n";
$result = json_decode($response, true);
if ($result) {
    echo json_encode($result, JSON_PRETTY_PRINT) . "\n";
    
    if (isset($result['InvoiceID'])) {
        echo "\n✅ SUCCESS: Invoice created in Xero!\n";
        echo "   Invoice ID: " . $result['InvoiceID'] . "\n";
        echo "   Invoice Number: " . $result['InvoiceNumber'] . "\n";
        echo "   Status: " . $result['Status'] . "\n";
        echo "   Date: " . $result['Date'] . "\n";
        echo "   Due Date: " . $result['DueDate'] . "\n";
    } else {
        echo "\n❌ ERROR: " . ($result['error'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Failed to parse JSON response\n";
}

echo "\n=== Test Complete ===\n";
?>
