<?php
// Test network connectivity to Xero
echo "Testing network connectivity to Xero...\n\n";

// Test 1: Basic connectivity to Xero
echo "1. Testing basic connectivity to Xero API...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.xero.com/connections');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ Error: $error\n";
} else {
    echo "   ✅ HTTP Code: $httpCode\n";
    if ($httpCode === 401) {
        echo "   ✅ Expected 401 (unauthorized) - API is reachable\n";
    }
}

// Test 2: Token endpoint
echo "\n2. Testing token endpoint...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://identity.xero.com/connect/token');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
    'grant_type' => 'authorization_code',
    'client_id' => 'test',
    'client_secret' => 'test',
    'redirect_uri' => 'test',
    'code' => 'test'
]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/x-www-form-urlencoded'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ Error: $error\n";
} else {
    echo "   ✅ HTTP Code: $httpCode\n";
    if ($httpCode === 400) {
        echo "   ✅ Expected 400 (bad request) - Token endpoint is reachable\n";
    }
}

// Test 3: Check if we can reach localhost
echo "\n3. Testing localhost connectivity...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/check-xero-status.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ Error: $error\n";
} else {
    echo "   ✅ HTTP Code: $httpCode\n";
    echo "   ✅ Response: " . substr($response, 0, 100) . "...\n";
}

echo "\n=== Network Test Complete ===\n";
?>
