<?php
// Test that Xero integration always uses PHP-generated data
echo "=== Testing PHP-Only Data Generation ===\n\n";

echo "1. Testing with no input data (should use PHP random data):\n";

// Make the API call without any invoice data
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php?action=create_invoice');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([])); // Empty data
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "   HTTP Code: $httpCode\n";
echo "   Raw Response: " . substr($response, 0, 500) . "\n";
if ($error) {
    echo "   Error: $error\n";
} else {
    $result = json_decode($response, true);
    if ($result && isset($result['InvoiceID'])) {
        echo "   ✅ SUCCESS: Invoice created with PHP-generated data!\n";
        echo "   Invoice ID: " . $result['InvoiceID'] . "\n";
        echo "   Invoice Number: " . $result['InvoiceNumber'] . "\n";
        echo "   Customer: " . $result['Contact']['Name'] . "\n";
        echo "   Total Line Items: " . count($result['LineItems']) . "\n";
        
        echo "\n2. Line Items (all PHP-generated):\n";
        foreach ($result['LineItems'] as $index => $item) {
            $lineTotal = ($item['Quantity'] ?? 1) * ($item['UnitAmount'] ?? 0);
            echo "   " . ($index + 1) . ". " . ($item['Description'] ?? 'Unknown') . "\n";
            echo "      Qty: " . ($item['Quantity'] ?? 1) . " x £" . number_format($item['UnitAmount'] ?? 0, 2) . " = £" . number_format($lineTotal, 2) . "\n";
        }
        
        $totalAmount = array_sum(array_map(function($item) {
            return ($item['Quantity'] ?? 1) * ($item['UnitAmount'] ?? 0);
        }, $result['LineItems']));
        echo "   Total Invoice Amount: £" . number_format($totalAmount, 2) . "\n";
        
    } else {
        echo "   ❌ ERROR: " . ($result['error'] ?? 'Unknown error') . "\n";
    }
}

echo "\n=== Test Complete ===\n";
echo "✅ The system now always uses PHP-generated random data!\n";
echo "✅ JavaScript data from the in-house app is completely ignored!\n";
?>
