<?php
// Test random wheel service invoice creation
echo "=== Testing Random Wheel Service Invoice ===\n\n";

// Random insurance company names with addresses and contact info
$insuranceCompanies = [
    [
        'name' => 'Aviva Insurance Ltd',
        'address' => ['line1' => 'St Helen\'s, 1 Undershaft', 'city' => 'London', 'postcode' => 'EC3P 3DQ', 'country' => 'United Kingdom'],
        'phone' => '0800 015 6000',
        'email' => 'customer.services@aviva.co.uk'
    ],
    [
        'name' => 'Direct Line Insurance',
        'address' => ['line1' => 'Direct Line House', 'city' => 'Bromley', 'postcode' => 'BR1 1DP', 'country' => 'United Kingdom'],
        'phone' => '0345 246 4404',
        'email' => 'help@directline.com'
    ],
    [
        'name' => 'Admiral Insurance',
        'address' => ['line1' => 'Admiral House', 'city' => 'Cardiff', 'postcode' => 'CF3 0LT', 'country' => 'United Kingdom'],
        'phone' => '0333 220 2000',
        'email' => 'customer.services@admiral.com'
    ],
    [
        'name' => 'Churchill Insurance',
        'address' => ['line1' => 'Churchill Court', 'city' => 'Bromley', 'postcode' => 'BR1 1DP', 'country' => 'United Kingdom'],
        'phone' => '0800 200 300',
        'email' => 'help@churchill.com'
    ],
    [
        'name' => 'More Than Insurance',
        'address' => ['line1' => 'More Than House', 'city' => 'Bromley', 'postcode' => 'BR1 1DP', 'country' => 'United Kingdom'],
        'phone' => '0800 980 8000',
        'email' => 'help@morethan.com'
    ],
    [
        'name' => 'LV= Insurance',
        'address' => ['line1' => 'LV= House', 'city' => 'Bournemouth', 'postcode' => 'BH1 1RH', 'country' => 'United Kingdom'],
        'phone' => '0800 032 0000',
        'email' => 'help@lv.com'
    ],
    [
        'name' => 'Hastings Direct',
        'address' => ['line1' => 'Hastings House', 'city' => 'Bexhill-on-Sea', 'postcode' => 'TN39 3LG', 'country' => 'United Kingdom'],
        'phone' => '0333 321 9803',
        'email' => 'help@hastingsdirect.com'
    ],
    [
        'name' => 'Esure Insurance',
        'address' => ['line1' => 'The Observatory', 'city' => 'Reigate', 'postcode' => 'RH2 0SG', 'country' => 'United Kingdom'],
        'phone' => '0345 604 7464',
        'email' => 'help@esure.com'
    ],
    [
        'name' => 'Tesco Bank Insurance',
        'address' => ['line1' => 'Tesco Bank House', 'city' => 'Edinburgh', 'postcode' => 'EH12 9FJ', 'country' => 'United Kingdom'],
        'phone' => '0345 300 3511',
        'email' => 'help@tescobank.com'
    ],
    [
        'name' => 'Sainsbury\'s Bank Insurance',
        'address' => ['line1' => 'Sainsbury\'s Bank', 'city' => 'Edinburgh', 'postcode' => 'EH12 9FJ', 'country' => 'United Kingdom'],
        'phone' => '0800 096 0079',
        'email' => 'help@sainsburysbank.co.uk'
    ],
    [
        'name' => 'Halifax Insurance',
        'address' => ['line1' => 'Halifax House', 'city' => 'Halifax', 'postcode' => 'HX1 1UZ', 'country' => 'United Kingdom'],
        'phone' => '0345 720 3040',
        'email' => 'help@halifax.co.uk'
    ],
    [
        'name' => 'Barclays Insurance',
        'address' => ['line1' => '1 Churchill Place', 'city' => 'London', 'postcode' => 'E14 5HP', 'country' => 'United Kingdom'],
        'phone' => '0800 158 3199',
        'email' => 'help@barclays.co.uk'
    ],
    [
        'name' => 'AA Insurance',
        'address' => ['line1' => 'Fanum House', 'city' => 'Basingstoke', 'postcode' => 'RG21 4EA', 'country' => 'United Kingdom'],
        'phone' => '0800 085 1371',
        'email' => 'help@theaa.com'
    ],
    [
        'name' => 'RAC Insurance',
        'address' => ['line1' => 'RAC House', 'city' => 'Walsall', 'postcode' => 'WS5 4AW', 'country' => 'United Kingdom'],
        'phone' => '0800 085 1371',
        'email' => 'help@rac.co.uk'
    ],
    [
        'name' => 'Green Flag Insurance',
        'address' => ['line1' => 'Green Flag House', 'city' => 'Leeds', 'postcode' => 'LS1 5DL', 'country' => 'United Kingdom'],
        'phone' => '0800 400 600',
        'email' => 'help@greenflag.com'
    ]
];

// Random services
$services = ['Powder Coat', 'Diamond Cut', 'Other'];

// Random registration numbers
$regNumbers = ['BM21 X5A', 'AU22 3FG', 'KJ45 LMN', 'AB12 CDE', 'XY99 ZAB', 'FG67 HIJ', 'KL89 MNO'];

// Generate random invoice data
$randomCompany = $insuranceCompanies[array_rand($insuranceCompanies)];
$randomService = $services[array_rand($services)];
$randomReg = $regNumbers[array_rand($regNumbers)];

$invoiceData = [
    'jobId' => rand(1000, 9999),
    'customer' => $randomCompany['name'],
    'customerAddress' => $randomCompany['address'],
    'customerPhone' => $randomCompany['phone'],
    'customerEmail' => $randomCompany['email'],
    'description' => '', // Let the system generate random description
    'amount' => 0, // Let the system generate random amount
    'service' => $randomService,
    'regNo' => $randomReg,
    'addons' => [] // Let the system generate random add-ons
];

echo "1. Random Invoice Data:\n";
echo "   Customer: " . $invoiceData['customer'] . "\n";
echo "   Address: " . $invoiceData['customerAddress']['line1'] . ", " . $invoiceData['customerAddress']['city'] . " " . $invoiceData['customerAddress']['postcode'] . "\n";
echo "   Phone: " . $invoiceData['customerPhone'] . "\n";
echo "   Email: " . $invoiceData['customerEmail'] . "\n";
echo "   Service: " . $invoiceData['service'] . "\n";
echo "   Registration: " . $invoiceData['regNo'] . "\n";
echo "   Job ID: " . $invoiceData['jobId'] . "\n";
echo "   Amount: Random (generated by system)\n";
echo "   Add-ons: Random (max 2, generated by system)\n\n";

echo "2. Calling Xero SDK API...\n";

// Make the API call
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php?action=create_invoice');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['invoiceData' => $invoiceData]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "3. API Response:\n";
echo "   HTTP Code: $httpCode\n";
echo "   Raw Response: " . substr($response, 0, 500) . "\n";
if ($error) {
    echo "   Error: $error\n";
} else {
    $result = json_decode($response, true);
    if ($result) {
        echo "4. Generated Invoice:\n";
        echo "   Invoice ID: " . ($result['InvoiceID'] ?? 'Unknown') . "\n";
        echo "   Invoice Number: " . ($result['InvoiceNumber'] ?? 'Unknown') . "\n";
        echo "   Status: " . ($result['Status'] ?? 'Unknown') . "\n";
        echo "   Customer: " . ($result['Contact']['Name'] ?? 'Unknown') . "\n";
        echo "   Total Line Items: " . count($result['LineItems'] ?? []) . "\n\n";
        
        echo "5. Line Items Breakdown:\n";
        $totalAmount = 0;
        foreach ($result['LineItems'] as $index => $item) {
            $lineTotal = ($item['Quantity'] ?? 1) * ($item['UnitAmount'] ?? 0);
            $totalAmount += $lineTotal;
            echo "   " . ($index + 1) . ". " . ($item['Description'] ?? 'Unknown') . "\n";
            echo "      Qty: " . ($item['Quantity'] ?? 1) . " x £" . number_format($item['UnitAmount'] ?? 0, 2) . " = £" . number_format($lineTotal, 2) . "\n";
        }
        echo "   Total Invoice Amount: £" . number_format($totalAmount, 2) . "\n\n";
        
        // Check if description contains powder coating or diamond cuts
        $hasPowderCoating = false;
        $hasDiamondCuts = false;
        foreach ($result['LineItems'] as $item) {
            $desc = strtolower($item['Description'] ?? '');
            if (strpos($desc, 'powder') !== false) $hasPowderCoating = true;
            if (strpos($desc, 'diamond') !== false) $hasDiamondCuts = true;
        }
        
        echo "6. Service Description Check:\n";
        echo "   Contains 'Powder Coating': " . ($hasPowderCoating ? "✅ YES" : "❌ NO") . "\n";
        echo "   Contains 'Diamond Cuts': " . ($hasDiamondCuts ? "✅ YES" : "❌ NO") . "\n";
        echo "   Add-ons Count: " . (count($result['LineItems']) - 1) . " (should be ≤ 2)\n";
        
        if (isset($result['InvoiceID'])) {
            echo "\n✅ SUCCESS: Random invoice created in Xero!\n";
        } else {
            echo "\n❌ ERROR: " . ($result['error'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Failed to parse JSON response\n";
    }
}

echo "\n=== Test Complete ===\n";
?>
