<?php
// Test token refresh functionality
echo "=== Testing Token Refresh ===\n\n";

require_once 'vendor/autoload.php';
require_once 'xero-sdk-api.php';

// Load current tokens
$tokens = json_decode(file_get_contents('xero_tokens.json'), true);
echo "1. Current tokens:\n";
echo "   Access Token: " . substr($tokens['access_token'], 0, 20) . "...\n";
echo "   Refresh Token: " . substr($tokens['refresh_token'], 0, 20) . "...\n";
echo "   Created At: " . date('Y-m-d H:i:s', $tokens['created_at']) . "\n";
echo "   Expires In: " . $tokens['expires_in'] . " seconds\n";
echo "   Expires At: " . date('Y-m-d H:i:s', $tokens['created_at'] + $tokens['expires_in']) . "\n";
echo "   Current Time: " . date('Y-m-d H:i:s') . "\n";
echo "   Is Expired: " . (time() > ($tokens['created_at'] + $tokens['expires_in']) ? 'YES' : 'NO') . "\n\n";

// Test getValidAccessToken function
echo "2. Testing getValidAccessToken():\n";
try {
    $validToken = getValidAccessToken();
    echo "   ✅ SUCCESS: Got valid token\n";
    echo "   New Token: " . substr($validToken, 0, 20) . "...\n";
    
    // Check if tokens were updated
    $newTokens = json_decode(file_get_contents('xero_tokens.json'), true);
    echo "   Updated Created At: " . date('Y-m-d H:i:s', $newTokens['created_at']) . "\n";
    echo "   Token Changed: " . ($tokens['access_token'] !== $newTokens['access_token'] ? 'YES' : 'NO') . "\n";
    
} catch (Exception $e) {
    echo "   ❌ ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== Test Complete ===\n";
?>
