<?php
// Test Xero Authorization
require_once 'vendor/autoload.php';

// Xero API Configuration
$XERO_CLIENT_ID = '4A904E9EF43249648C8CA3198BC84627';
$XERO_REDIRECT_URI = 'http://localhost/mvps/RefurbFlow-ordering-system/in-house-app/xero-sdk-api.php';
$XERO_SCOPE = 'accounting.transactions accounting.contacts.read accounting.settings.read offline_access';

// Generate authorization URL
$authUrl = 'https://login.xero.com/identity/connect/authorize' . '?' . http_build_query([
    'response_type' => 'code',
    'client_id' => $XERO_CLIENT_ID,
    'redirect_uri' => $XERO_REDIRECT_URI,
    'scope' => $XERO_SCOPE,
    'state' => 'xero_auth_state'
]);

echo "Xero Authorization URL:\n";
echo $authUrl . "\n\n";
echo "Click this URL to authorize the app:\n";
echo "<a href='$authUrl' target='_blank'>Authorize Xero App</a>\n";
?>
