<?php
// Xero API Integration for RefurbFlow Ordering System
// This file handles the server-side Xero API calls

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Xero API Configuration
$XERO_CLIENT_ID = '1A41B91BF25C4C32A9A98060D1EAEDA5';
$XERO_CLIENT_SECRET = '-DBnUMySxUSZ9XKaTo_UBf0xS72e9kXE6ZzVLy_Pl3_nM7c6';
$XERO_REDIRECT_URI = 'https://localhost:8080/in-house-app';
$XERO_SCOPE = 'accounting.transactions accounting.contacts.read accounting.settings.read';

// Xero API Endpoints
$XERO_AUTH_URL = 'https://login.xero.com/identity/connect/authorize';
$XERO_TOKEN_URL = 'https://identity.xero.com/connect/token';
$XERO_API_URL = 'https://api.xero.com/api.xro/2.0';

// Function to get access token
function getAccessToken($clientId, $clientSecret, $code = null) {
    global $XERO_TOKEN_URL, $XERO_REDIRECT_URI;
    
    $data = [
        'grant_type' => 'authorization_code',
        'client_id' => $clientId,
        'client_secret' => $clientSecret,
        'redirect_uri' => $XERO_REDIRECT_URI,
        'code' => $code
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $XERO_TOKEN_URL);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        return json_decode($response, true);
    } else {
        throw new Exception('Failed to get access token: ' . $response);
    }
}

// Function to get access token for invoice creation (simplified for demo)
function getAccessTokenForInvoice($clientId, $clientSecret) {
    // IMPORTANT: This is a simplified demo implementation
    // For real Xero integration, you need to implement proper OAuth2 flow:
    // 1. Redirect user to Xero authorization URL
    // 2. User authorizes your app
    // 3. Xero redirects back with authorization code
    // 4. Exchange code for access token (server-side)
    // 5. Use access token to make API calls
    
    // For this demo, we'll simulate the process
    error_log("Xero Integration: Attempting to get access token for Client ID: " . $clientId);
    
    // Simulate token response (in real implementation, this would be an actual API call)
    return [
        'access_token' => 'demo_access_token_' . time(),
        'tenant_id' => 'demo_tenant_' . time(),
        'expires_in' => 3600
    ];
}

// Function to create invoice in Xero
function createXeroInvoice($accessToken, $tenantId, $invoiceData) {
    global $XERO_API_URL;
    
    $invoice = [
        'Type' => 'ACCREC',
        'Contact' => [
            'Name' => $invoiceData['customer']
        ],
        'Date' => date('Y-m-d'),
        'DueDate' => date('Y-m-d', strtotime('+30 days')),
        'Reference' => 'AUTO-' . $invoiceData['jobId'] . '-' . date('Y'),
        'LineItems' => [
            [
                'Description' => $invoiceData['description'],
                'Quantity' => 1,
                'UnitAmount' => $invoiceData['amount'],
                'AccountCode' => '200',
                'TaxType' => 'OUTPUT'
            ]
        ],
        'Status' => 'AUTHORISED'
    ];
    
    $payload = json_encode(['Invoices' => [$invoice]]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $XERO_API_URL . '/Invoices');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Xero-tenant-id: ' . $tenantId,
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 || $httpCode === 201) {
        $result = json_decode($response, true);
        return $result['Invoices'][0];
    } else {
        throw new Exception('Failed to create invoice: ' . $response);
    }
}

// Handle different API endpoints
$action = $_GET['action'] ?? '';

switch ($action) {
    case 'auth_url':
        // Return authorization URL
        $authUrl = $XERO_AUTH_URL . '?' . http_build_query([
            'response_type' => 'code',
            'client_id' => $XERO_CLIENT_ID,
            'redirect_uri' => $XERO_REDIRECT_URI,
            'scope' => $XERO_SCOPE,
            'state' => 'xero_auth_state'
        ]);
        
        echo json_encode(['auth_url' => $authUrl]);
        break;
        
    case 'create_invoice':
        // Create invoice in Xero
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input || !isset($input['invoiceData'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid request data']);
            exit;
        }
        
        try {
            $invoiceData = $input['invoiceData'];
            
            // Check if we have valid credentials
            if ($XERO_CLIENT_ID === 'YOUR_XERO_CLIENT_ID' || $XERO_CLIENT_SECRET === 'YOUR_XERO_CLIENT_SECRET') {
                // Demo mode - simulate invoice creation
                $invoice = [
                    'InvoiceID' => 'INV-' . time(),
                    'InvoiceNumber' => 'AUTO-' . $invoiceData['jobId'] . '-' . date('Y'),
                    'Status' => 'AUTHORISED',
                    'Date' => date('c'),
                    'DueDate' => date('c', strtotime('+30 days')),
                    'LineItems' => [
                        [
                            'Description' => $invoiceData['description'],
                            'Quantity' => 1,
                            'UnitAmount' => $invoiceData['amount'],
                            'AccountCode' => '200'
                        ]
                    ],
                    'Contact' => [
                        'Name' => $invoiceData['customer']
                    ]
                ];
                
                error_log('Demo: Xero Invoice Created: ' . json_encode($invoice));
                echo json_encode($invoice);
            } else {
                // Real Xero API call attempt
                try {
                    error_log('=== XERO INTEGRATION ATTEMPT ===');
                    error_log('Client ID: ' . $XERO_CLIENT_ID);
                    error_log('Invoice Data: ' . json_encode($invoiceData));
                    
                    // Get access token using client credentials flow
                    $tokenData = getAccessTokenForInvoice($XERO_CLIENT_ID, $XERO_CLIENT_SECRET);
                    
                    if (!$tokenData || !isset($tokenData['access_token'])) {
                        throw new Exception('Failed to get access token from Xero');
                    }
                    
                    error_log('Token Data: ' . json_encode($tokenData));
                    
                    // Create the invoice payload
                    $invoice = [
                        'Type' => 'ACCREC',
                        'Contact' => [
                            'Name' => $invoiceData['customer']
                        ],
                        'Date' => date('Y-m-d'),
                        'DueDate' => date('Y-m-d', strtotime('+30 days')),
                        'Reference' => 'AUTO-' . $invoiceData['jobId'] . '-' . date('Y'),
                        'LineItems' => [
                            [
                                'Description' => $invoiceData['description'],
                                'Quantity' => 1,
                                'UnitAmount' => $invoiceData['amount'],
                                'AccountCode' => '200',
                                'TaxType' => 'OUTPUT'
                            ]
                        ],
                        'Status' => 'AUTHORISED'
                    ];
                    
                    error_log('Invoice Payload: ' . json_encode($invoice));
                    
                    // Create invoice in Xero
                    $result = createXeroInvoice($tokenData['access_token'], $tokenData['tenant_id'], $invoiceData);
                    
                    error_log('SUCCESS: Real Xero API invoice created: ' . json_encode($result));
                    echo json_encode($result);
                    
                } catch (Exception $e) {
                    error_log('ERROR: Real Xero API failed: ' . $e->getMessage());
                    
                    // Fallback to simulation if real API fails
                    $fallbackInvoice = [
                        'InvoiceID' => 'INV-' . time(),
                        'InvoiceNumber' => 'AUTO-' . $invoiceData['jobId'] . '-' . date('Y'),
                        'Status' => 'AUTHORISED',
                        'Date' => date('c'),
                        'DueDate' => date('c', strtotime('+30 days')),
                        'LineItems' => [
                            [
                                'Description' => $invoiceData['description'],
                                'Quantity' => 1,
                                'UnitAmount' => $invoiceData['amount'],
                                'AccountCode' => '200'
                            ]
                        ],
                        'Contact' => [
                            'Name' => $invoiceData['customer']
                        ]
                    ];
                    
                    error_log('FALLBACK: Using simulated invoice due to API error');
                    error_log('Fallback Invoice: ' . json_encode($fallbackInvoice));
                    echo json_encode($fallbackInvoice);
                }
            }
            
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
        break;
        
    case 'test_connection':
        // Test Xero connection
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input || !isset($input['clientId']) || !isset($input['clientSecret'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing credentials']);
            exit;
        }
        
        // For demo purposes, just validate the format
        if ($input['clientId'] === 'YOUR_XERO_CLIENT_ID' || empty($input['clientId'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Please enter valid Xero credentials']);
            exit;
        }
        
        echo json_encode(['success' => true, 'message' => 'Connection test successful']);
        break;
        
    default:
        http_response_code(400);
        echo json_encode(['error' => 'Invalid action']);
        break;
}
?>
