// Shared constants for the wheel refurbishment system

const JOB_STATUS = {
    PENDING: 'pending',
    QUOTED: 'quoted',
    IN_PROGRESS: 'in-progress',
    COMPLETED: 'completed',
    CANCELLED: 'cancelled'
};

const JOB_PRIORITY = {
    LOW: 'low',
    MEDIUM: 'medium',
    HIGH: 'high',
    URGENT: 'urgent'
};

const JOB_URGENCY = {
    STANDARD: 'standard',
    URGENT: 'urgent',
    RUSH: 'rush'
};

const USER_ROLES = {
    CLIENT: 'client',
    STAFF: 'staff',
    ADMIN: 'admin'
};

const NOTIFICATION_TYPES = {
    SUCCESS: 'success',
    ERROR: 'error',
    INFO: 'info',
    WARNING: 'warning'
};

const API_ENDPOINTS = {
    JOBS: '/api/jobs',
    CUSTOMERS: '/api/customers',
    QUOTES: '/api/quotes',
    INVOICES: '/api/invoices',
    AUTH: '/api/auth',
    UPLOAD: '/api/upload'
};

const XERO_INTEGRATION = {
    INVOICE_ENDPOINT: '/api/xero/invoices',
    CUSTOMER_ENDPOINT: '/api/xero/customers',
    PAYMENT_ENDPOINT: '/api/xero/payments'
};

// Export for use in both applications
if (typeof module !== 'undefined' && module.exports) {
    module.exports = {
        JOB_STATUS,
        JOB_PRIORITY,
        JOB_URGENCY,
        USER_ROLES,
        NOTIFICATION_TYPES,
        API_ENDPOINTS,
        XERO_INTEGRATION
    };
}
